<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Model_Log extends XenForo_Model
{
    
    public static function template($name)
    {
        return self::$$name;
    }

    public function clean()
    {
        return $this->_getDb()->query("
            TRUNCATE TABLE `xf_sonnb_stop_spam_log`
        ");
    }

    public function getLog($id)
    {
        $return =  $this->_getDb()->fetchRow("
            SELECT * FROM `xf_sonnb_stop_spam_log`
            WHERE id='$id'
        ");
        
        return $this->prepareLog($return);
    }

    public function countTotal()
    {
        return $this->_getDb()->fetchOne('
            SELECT COUNT(*) FROM `xf_sonnb_stop_spam_log`
        ');
    }

    public function getLogs($limit, $offset)
    {
        $return =  $this->_getDb()->fetchAssoc("
            SELECT * FROM `xf_sonnb_stop_spam_log`
            ORDER BY time DESC
            LIMIT $limit OFFSET $offset
        ");
        
        return $this->prepareLogs($return);
    }
    
    public function prepareLogs(array $logs)
    {
        if ($logs)
        {
            foreach ($logs as &$log)
            {
                $log = $this->prepareLog($log);
            }
        }
        
        return $logs;
    }
    
    public function prepareLog(array $log)
    {
        if (!empty($log))
        {
            if ($log['action'] == sonnbStopSpamHere_Model_SSH::ACTION_BLOCK)
            {
                $log['content_link'] = '';
            }
            else
            {
                switch ($log['content_type'])
                {
                    case sonnbStopSpamHere_Model_SSH::TYPE_THREAD:
                        $log['content_link'] = XenForo_Link::buildPublicLink('threads', array('thread_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_POST:
                        $log['content_link'] = XenForo_Link::buildPublicLink('posts', array('post_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION:
                        $log['content_link'] = XenForo_Link::buildPublicLink('conversations', array('conversation_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION_REPLY:
                        $conversation = $this->getModelFromCache('XenForo_Model_Conversation')->getConversationMessageById($log['content_id']);
                        $log['content_link'] = XenForo_Link::buildPublicLink('conversations/message', $conversation, array('message_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST:
                        $log['content_link'] = XenForo_Link::buildPublicLink('profile-posts', array('profile_post_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT:
                        $profilePost = $this->getModelFromCache('XenForo_Model_ProfilePost')->getProfilePostCommentById($log['content_id']);
                        $log['content_link'] = XenForo_Link::buildPublicLink('profile-posts', $profilePost, array('profile_post_comment_id'=>$log['content_id']));
                        break;
                    case sonnbStopSpamHere_Model_SSH::TYPE_REGISTER:
                        $log['content_link'] = XenForo_Link::buildPublicLink('members', array('user_id'=>$log['content_id']));
                        break;
                }
            }
            
            if ($log['data'])
            {
                $data = unserialize($log['data']);
                if ($data)
                {
                    $log['data'] = '<pre>'.print_r($data, true).'</pre>';
                }
                else
                {
                    $log['data'] = '';
                }
            }
            
            $log['reason'] = sonnbStopSpamHere_Model_Moderate::getReason(array('type' => $log['log_type']));
        }
        
        return $log;
    }

    public static function getContactUrl()
    {
        $xenOptions = XenForo_Application::getOptions();
        $contactUrl = $xenOptions->contactUrl;
        if ($contactUrl['type'] == 'default')
        {
            $contactUrl = XenForo_Link::buildPublicLink('canonical:misc/contact');
        }
        else if ($contactUrl['type'] == 'custom')
        {
            $contactUrl = $contactUrl['custom'];
        }
        else
        {
            $contactUrl = '';
        }

        return $contactUrl;
    }

}

?>
